
import crafttweaker.oredict.IOreDictEntry;
import crafttweaker.item.IIngredient;

function genRecipesForOredict(dict as IOreDictEntry,basename as string){
    for i,item in dict.items {
        if(i>0){
            recipes.remove(item, false);
        }
        var grid=[] as IIngredient[];
        if(i>0){
            for j in 0 to i {
                grid+=null;
            }
        }
        grid+=dict;
        if(i<8){
            for k in (i+1) to 9 {
                grid+=null;
            }
        }
        recipes.addShaped(dict.name+"_convert_"+i, item,[
            [grid[0],grid[1],grid[2]],
            [grid[3],grid[4],grid[5]],
            [grid[6],grid[7],grid[8]]
        ]);
    }
}

<ore:toolAxeSteel>.add(<railcraft:tool_axe_steel>,<thermalfoundation:tool.axe_steel>,<immersiveengineering:axe_steel>);
genRecipesForOredict(<ore:toolAxeSteel>,"steel_axe");
<ore:toolshovelSteel>.add(<railcraft:tool_shovel_steel>,<thermalfoundation:tool.shovel_steel>,<immersiveengineering:shovel_steel>);
genRecipesForOredict(<ore:toolshovelSteel>,"steel_shovel");
<ore:toolpickaxeSteel>.add(<railcraft:tool_pickaxe_steel>,<thermalfoundation:tool.pickaxe_steel>,<immersiveengineering:pickaxe_steel>);
genRecipesForOredict(<ore:toolpickaxeSteel>,"steel_pickaxe");
<ore:toolhoeSteel>.add(<railcraft:tool_hoe_steel>,<thermalfoundation:tool.hoe_steel>,<immersiveengineering:hoe_steel>);
genRecipesForOredict(<ore:toolhoeSteel>,"steel_hoe");
<ore:toolswordSteel>.add(<railcraft:tool_sword_steel>,<thermalfoundation:tool.sword_steel>,<immersiveengineering:sword_steel>);
genRecipesForOredict(<ore:toolswordSteel>,"steel_sword");
<ore:armorHelmetSteel>.add(<railcraft:armor_helmet_steel>,<thermalfoundation:armor.helmet_steel>,<immersiveengineering:steel_armor_head>);
genRecipesForOredict(<ore:armorHelmetSteel>,"steel_helmet");
<ore:armorchestplateSteel>.add(<railcraft:armor_chestplate_steel>,<thermalfoundation:armor.plate_steel>,<immersiveengineering:steel_armor_chest>);
genRecipesForOredict(<ore:armorchestplateSteel>,"steel_chestplate");
<ore:armorleggingsSteel>.add(<railcraft:armor_leggings_steel>,<thermalfoundation:armor.legs_steel>,<immersiveengineering:steel_armor_legs>);
genRecipesForOredict(<ore:armorleggingsSteel>,"steel_leggings");
<ore:armorBootsSteel>.add(<railcraft:armor_boots_steel>,<thermalfoundation:armor.boots_steel>,<immersiveengineering:steel_armor_feet>);
genRecipesForOredict(<ore:armorBootsSteel>,"steel_boots");
<ore:toolShearsSteel>.add(<railcraft:tool_shears_steel>,<thermalfoundation:tool.shears_steel>);
genRecipesForOredict(<ore:toolShearsSteel>,"toolShearsSteel");

<ore:toolAxeBronze>.add(<ic2:bronze_axe>,<thermalfoundation:tool.axe_bronze>,<mekanismtools:bronzeaxe>);
genRecipesForOredict(<ore:toolAxeBronze>,"bronze_axe");
<ore:toolshovelBronze>.add(<ic2:bronze_shovel>,<thermalfoundation:tool.shovel_bronze>,<mekanismtools:bronzeshovel>);
genRecipesForOredict(<ore:toolshovelBronze>,"bronze_shovel");
<ore:toolpickaxeBronze>.add(<ic2:bronze_pickaxe>,<thermalfoundation:tool.pickaxe_bronze>,<mekanismtools:bronzepickaxe>);
genRecipesForOredict(<ore:toolpickaxeBronze>,"bronze_pickaxe");
<ore:toolhoeBronze>.add(<ic2:bronze_hoe>,<thermalfoundation:tool.hoe_bronze>,<mekanismtools:bronzehoe>);
genRecipesForOredict(<ore:toolhoeBronze>,"bronze_hoe");
<ore:toolswordBronze>.add(<ic2:bronze_sword>,<thermalfoundation:tool.sword_bronze>,<mekanismtools:bronzesword>);
genRecipesForOredict(<ore:toolswordBronze>,"bronze_sword");
<ore:armorHelmetBronze>.add(<ic2:bronze_helmet>,<thermalfoundation:armor.helmet_bronze>,<mekanismtools:bronzehelmet>);
genRecipesForOredict(<ore:armorHelmetBronze>,"bronze_helmet");
<ore:armorchestplateBronze>.add(<ic2:bronze_chestplate>,<thermalfoundation:armor.plate_bronze>,<mekanismtools:bronzechestplate>);
genRecipesForOredict(<ore:armorchestplateBronze>,"bronze_chestplate");
<ore:armorleggingsBronze>.add(<ic2:bronze_leggings>,<thermalfoundation:armor.legs_bronze>,<mekanismtools:bronzeleggings>);
genRecipesForOredict(<ore:armorleggingsBronze>,"bronze_leggings");
<ore:armorBootsBronze>.add(<ic2:bronze_boots>,<thermalfoundation:armor.boots_bronze>,<mekanismtools:bronzeboots>);
genRecipesForOredict(<ore:armorBootsBronze>,"bronze_boots");
