import crafttweaker.liquid.ILiquidStack;
import crafttweaker.item.IIngredient;
function getTemp(tempCelsius as double, amount as double) as int{
    var base = 1296 as double;
    var max_tmp = max(0, tempCelsius) as double;
    var f = amount / base;

    f = pow(f, 0.31546487678 as double) as double;

    return 300 + (f * max_tmp) as int;
}
function addTemperaturedRecipe(fluid as ILiquidStack,input as IIngredient,basetemp as int){
    mods.tconstruct.Melting.addRecipe(fluid, input,getTemp(basetemp,fluid.amount));
}
mods.tconstruct.Melting.addRecipe(<liquid:emerald> * 144,<ore:dustEmerald>, 866);
// mods.tconstruct.Melting.addRecipe(<liquid:advancedalloy> * 144,<ore:plateAdvancedAlloy>, 600);

mods.tconstruct.Melting.addRecipe(<liquid:copper> * 288,<ore:compressedCopper>, 450);
mods.tconstruct.Melting.addRecipe(<liquid:tin> * 288,<ore:compressedTin>, 331);
mods.tconstruct.Melting.addRecipe(<liquid:aluminum> * 288,<ore:compressedAluminum>, 318);
mods.tconstruct.Melting.addRecipe(<liquid:steel> * 288,<ore:compressedSteel>, 537);
mods.tconstruct.Melting.addRecipe(<liquid:bronze> * 288,<ore:compressedBronze>, 408);
mods.tconstruct.Melting.addRecipe(<liquid:iron> * 288,<ore:compressedIron>, 591);
mods.tconstruct.Melting.addRecipe(<liquid:titanium> * 288, <galacticraftplanets:item_basic_asteroids:6>, 984);


mods.tconstruct.Melting.addRecipe(<liquid:bronze> * 72, <ic2:casing:0>,370);
mods.tconstruct.Melting.addRecipe(<liquid:copper> * 72, <ic2:casing:1>,397);
mods.tconstruct.Melting.addRecipe(<liquid:gold> * 72, <ic2:casing:2>,393);
mods.tconstruct.Melting.addRecipe(<liquid:iron> * 72, <ic2:casing:3>,488);
mods.tconstruct.Melting.addRecipe(<liquid:lead> * 72, <ic2:casing:4>,340);
mods.tconstruct.Melting.addRecipe(<liquid:steel> * 72, <ic2:casing:5>,453);
mods.tconstruct.Melting.addRecipe(<liquid:tin> * 72, <ic2:casing:6>,320);
mods.tconstruct.Melting.addRecipe(<liquid:dark_steel> * 72, <contenttweaker:dark_steel_casing>,907);


mods.tconstruct.Melting.removeRecipe(<liquid:tin>, <ic2:cable:4>);
addTemperaturedRecipe(<liquid:tin> * 36, <ic2:cable:4>.withTag({type: 4 as byte, insulation: 0 as byte}),50);

mods.tconstruct.Melting.removeRecipe(<liquid:copper>, <ic2:cable:0>);
addTemperaturedRecipe(<liquid:copper> * 48, <ic2:cable>.withTag({type: 0 as byte, insulation: 0 as byte}),242);

mods.tconstruct.Melting.removeRecipe(<liquid:gold>, <ic2:cable:2>);
addTemperaturedRecipe(<liquid:gold> * 24, <ic2:cable:2>.withTag({type: 2 as byte, insulation: 0 as byte}),232);

mods.tconstruct.Melting.removeRecipe(<liquid:refinediron>, <ic2:cable:3>);
addTemperaturedRecipe(<liquid:iron> * 24, <ic2:cable:3>.withTag({type: 3 as byte, insulation: 0 as byte}),469);

addTemperaturedRecipe(<liquid:iron> * 576, <ic2:resource:12>,469);
