#reloadable
import mods.questtweaker.FunctionManager;
import crafttweaker.util.Position3f;
import crafttweaker.event.EntityMountEvent;
import crafttweaker.entity.IEntity;
import crafttweaker.player.IPlayer;
import crafttweaker.util.Math;
import crafttweaker.entity.IEntityDefinition;
import crafttweaker.data.IData;

static playerMountLocations as Position3f[IEntity] = {} ;
// static carts as string[] = ["minecraft:minecart",
// "railcraft:cart_basic",
// "railcraft:cart_bed"];

static carts as IEntityDefinition[] = [<entity:minecraft:minecart>,
<entity:railcraft:cart_basic>,
<entity:railcraft:cart_bed>];

function isMinecart(entity as IEntity) as bool{
    if(entity){
        return carts in entity.definition;
    }
    return false;
}

events.onEntityMount(function(event as EntityMountEvent){
    val mountingEntity = event.mountingEntity;
    if(mountingEntity instanceof IPlayer && !event.world.remote){
        val player as IPlayer = mountingEntity;
        val mount = event.mountedEntity;
        if(isMinecart(mount)){
            playerMountLocations[player] = crafttweaker.util.Position3f.create(mount.x, mount.y, mount.z);
        }
    }
});

FunctionManager.addFunction("on_a_rail",function(player as IPlayer){
    if(!isMinecart(player.getRidingEntity())){
        return 0 as long;
    }
    val startPos = playerMountLocations[player];
    if(startPos){
        var distance = Math.sqrt(pow(startPos.x-player.x,2)+pow(startPos.y-player.y,2)+pow(startPos.z-player.z,2));
        return Math.floor(distance);
    }
    return 0 as long;
});

FunctionManager.addFunction("high_speed_cart",function(player as IPlayer){
    if(!isMinecart(player.getRidingEntity())){
        return 0 as long;
    }
    val cart as IEntity = player.getRidingEntity();
    val data = cart.getNBT().memberGet("ForgeData");
    if(!isNull(data)){
        val result = data.memberGet("HighSpeed");
        if(!isNull(result)){
            return result.asInt() as long;
        }
        return 0 as long;
    }
    return 0 as long;
});
