#reloadable
import mods.questtweaker.FunctionManager;
import mods.questtweaker.QuestManager;
import crafttweaker.util.Position3f;
import crafttweaker.entity.IEntity;
import crafttweaker.player.IPlayer;

import crafttweaker.util.Math;
import crafttweaker.block.IBlock;
import crafttweaker.block.IBlockDefinition;
import crafttweaker.world.IBlockPos;
import crafttweaker.event.PlayerInteractBlockEvent;
import crafttweaker.events.IEventManager;
import crafttweaker.data.IData;
import mods.questtweaker.quests.ITaskData;

static computers as IBlockDefinition[] = [
    <block:opencomputers:case1>.block.definition,
    <block:opencomputers:case2>.block.definition,
    <block:opencomputers:case3>.block.definition,
];

function ocComputerOn(event as PlayerInteractBlockEvent) as bool{
    val taskData as ITaskData = ITaskData.getTaskData(event.player, "8fe9d4ee");
    if(isNull(taskData) || !taskData.isActive()){
        return false;
    }
    val block as IBlock = event.block;
    if((computers has block.definition) && !isNull(block.data)){
        val data as IData = block.data;
        val computerData as IData = data.memberGet("oc:computer");
        if(!isNull(computerData) && !isNull(computerData.uptime)){
            val uptime as int = computerData.uptime.asInt();
            taskData.setProgress(uptime);
            return true;
        }
    }
    return false;
}

events.onPlayerInteractBlock(function(event as PlayerInteractBlockEvent){
    if(!isNull(event.player) && !event.world.remote){
        ocComputerOn(event);
    }
});
