#reloadable
import mods.questtweaker.FunctionManager;
import mods.questtweaker.QuestManager;
import crafttweaker.util.Position3f;
import crafttweaker.entity.IEntity;
import crafttweaker.player.IPlayer;

import crafttweaker.util.Math;
import crafttweaker.block.IBlock;
import crafttweaker.block.IBlockDefinition;
import crafttweaker.world.IBlockPos;
import crafttweaker.event.PlayerInteractBlockEvent;
import crafttweaker.events.IEventManager;
import crafttweaker.data.IData;
import mods.questtweaker.quests.ITaskData;

static engines as IBlockDefinition[] = [<block:buildcraftcore:engine>.block.definition];

function bcEngineEvent(event as PlayerInteractBlockEvent) as bool{
    val taskData as ITaskData = ITaskData.getTaskData(event.player, "d62cf22e");
    if(isNull(taskData) || !taskData.isActive()){
        return false;
    }
    val block as IBlock = event.block;
    if((engines has block.definition) && !isNull(block.data)){
        val data as IData = block.data;
        if(!isNull(data.heat)){
            val heat = data.heat.asFloat();
            val longHeat as long = Math.floor(heat);
            taskData.setProgress(longHeat);
            return true;
        }
    }
    return false;
}

events.onPlayerInteractBlock(function(event as PlayerInteractBlockEvent){
    if(!isNull(event.player) && !event.world.remote){
        bcEngineEvent(event);
    }
});
