#loader crafttweaker
#priority -100000
import mods.ItemStages;
import mods.MobStages;
import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.mods.IMod;
import crafttweaker.mods.ILoadedMods;
import crafttweaker.oredict.IOreDictEntry;

val version_1_6="techstage2";
val version_1_7="techstage3";
val version_1_10="techstage4";
val version_1_12="techstage5";

function setItemStage (gamestage as string, items as IIngredient[]) {
    for item in items{
        mods.ItemStages.addItemStage(gamestage, item);
        mods.recipestages.Recipes.setRecipeStage(gamestage, item);
    }
}

function setModStage(gamestage as string,modid as string,excludedItems as IItemStack[] = []){
    if(loadedMods in modid){
        print("Setting stage "+gamestage+" for "+modid+" !");
        val mod = loadedMods[modid];
        for item in mod.items {
            if (excludedItems has item){
                mods.recipestages.Recipes.setRecipeStage(gamestage, item);
            }
        }
    }else{
        print("Modid "+modid+" not found!");
    }
    mods.ItemStages.stageModItems(gamestage, modid);
    for item in excludedItems{
        mods.ItemStages.removeItemStage(item);
    }
}

setModStage(version_1_6, "thermalexpansion");
setModStage(version_1_6, "thermaldynamics");
setModStage(version_1_6, "enderio");
setModStage(version_1_6, "industrialforegoing");
setModStage(version_1_6, "industrialmeat");

setModStage(version_1_7, "appliedenergistics2", [<appliedenergistics2:material:4>,<appliedenergistics2:material:5>, <appliedenergistics2:material:3>, <appliedenergistics2:material:46>]);
setModStage(version_1_7, "ae2wtlib");
setModStage(version_1_7, "wct");
setModStage(version_1_7, "wft");
setModStage(version_1_7, "wit");
setModStage(version_1_7, "wpt");
setModStage(version_1_7, "immersiveengineering");
setModStage(version_1_7, "rftools");
setModStage(version_1_7, "rftoolsdim");
setModStage(version_1_7, "ae2stuff");
setModStage(version_1_7, "opencomputers");

setModStage(version_1_7, "industrialwires");
setModStage(version_1_7, "redstonearsenal");
setModStage(version_1_7, "thermalinnovation");
setModStage(version_1_7, "immersivepetroleum");

setModStage(version_1_10, "psi");
setModStage(version_1_10, "rpsideas");
setModStage(version_1_10, "xnet");

setModStage(version_1_12, "mekanism",[<mekanism:salt>,<mekanism:saltblock>]);
setModStage(version_1_12, "mekanismgenerators");
setModStage(version_1_12, "mekanismtools");
setModStage(version_1_12, "threng");
setModStage(version_1_12, "wirelessutils");

val stagedItems_1_6=[
<minecraft:comparator>,
<minecraft:dropper>,
<minecraft:hopper>,
<minecraft:hopper_minecart>,
<tconstruct:wooden_hopper>,
<minecraft:daylight_detector>,
<minecraft:light_weighted_pressure_plate>,
<minecraft:heavy_weighted_pressure_plate>,
<minecraft:name_tag>,
<minecraft:lead>,
<ic2:forge_hammer>,
<ic2:resource:12>,
<ic2:resource:13>,
<ic2:casing:*>,
<ic2:te:5>,<ic2:te:17>,<ic2:te:19>,<ic2:te:18>,<ic2:te:20>,<ic2:te:21>,<ic2:te:16>,//Kinetic
<ic2:te:9>,<ic2:te:13>,<ic2:te:15>,<ic2:te:12>,<ic2:te:50>,<ic2:te:53>,<ic2:te:31>,<ic2:te:34>,<ic2:te:14>,//Heat
<ic2:te:55>,<ic2:te:56>,<ic2:te:52>,//EXP Processors
<ic2:resource:14>,
<ic2:te:26>,<ic2:te:23>,<ic2:te:25>,//Fluid Reactor
<ic2:te:61>,<ic2:te:64>,<ic2:te:62>,<ic2:te:63>,//Fluid UU
<ic2:te:57>,
<ic2:te:7>,
<ic2:te:6>,
<ic2:te:42>,
<ic2:te:27>,
<ic2:te:28>,
<ic2:te:29>,
<ic2:te:30>,
<ic2:te:33>,
<ic2:te:35>,
<ic2:te:38>,
<ic2:te:51>,
<ic2:te:83>,
<ic2:te:84>,
<ic2:te:85>,
<ic2:te:87>,
<ic2:te:88>,
<ic2:te:89>,
<ic2:te:90>,
<ic2:te:91>,
<ic2:te:112>,<ic2:te:113>,<ic2:te:114>,<ic2:te:131>,<ic2:te:132>,<ic2:te:133>,<ic2:te:134>,//Storage Boxes
<ic2:nuclear:0>,<ic2:nuclear:1>,<ic2:nuclear:2>,<ic2:nuclear:3>,
<ic2:nuclear:4>,<ic2:nuclear:5>,<ic2:nuclear:6>,<ic2:nuclear:7>,
<ic2:nuclear:8>,<ic2:nuclear:9>,<ic2:nuclear:10>,<ic2:nuclear:14>,
<ic2:nuclear:15>,<ic2:nuclear:16>,//EXP Nuclear Components
<ic2:mox_fuel_rod>,
<ic2:dual_mox_fuel_rod>,
<ic2:quad_mox_fuel_rod>,
<ic2:crafting:25>,
<ic2:crafting:27>,
<ic2:crafting:29>,<ic2:crafting:30>,<ic2:crafting:31>,<ic2:crafting:32>,
<ic2:crafting:33>,<ic2:crafting:34>,<ic2:crafting:41>,<ic2:crafting:42>,//Blades and Shafts
<ic2:crafting:35>,
<ic2:crafting:36>,
<ic2:tool_box>,
<ic2:fluid_cell>,
<ic2:block_cutting_blade:*>,
<ic2:rotor_wood>,
<ic2:rotor_iron>,
<ic2:rotor_bronze>,
<ic2:rotor_steel>,
<ic2:rotor_carbon>,
<galacticraftplanets:item_basic_asteroids:7>,
<galacticraftplanets:thermal_padding:0>,
<galacticraftplanets:thermal_padding:1>,    
<galacticraftplanets:thermal_padding:2>,
<galacticraftplanets:thermal_padding:3>,
<mtetweaks:road_block>,
<mtetweaks:road_lamp>,
<mtetweaks:road_lamp_invert_lit>] as IIngredient[];
setItemStage(version_1_6,stagedItems_1_6);

val stagedItems_1_7=[
    <extrautils2:analogcrafter>,
    <extrautils2:angelblock>,
    <extrautils2:angelring>.anyDamage(),
    <extrautils2:book>,
    <extrautils2:boomerang>,
    <extrautils2:chickenring:*>,
    <extrautils2:crafter>,
    <extrautils2:drum>.anyDamage(),
    <extrautils2:enderlilly>,
    <extrautils2:endershard>,
    <extrautils2:fireaxe>,
    <extrautils2:flattransfernode:*>,
    <extrautils2:glasscutter>,
    <extrautils2:goldenlasso>,
    <extrautils2:grocket:*>,
    <extrautils2:ingredients:1>,
    <extrautils2:ingredients:2>,
    <extrautils2:ingredients:3>,
    <extrautils2:ingredients:4>,
    <extrautils2:ingredients:6>,
    <extrautils2:ingredients:7>,
    <extrautils2:ingredients:8>,
    <extrautils2:ingredients:9>,
    <extrautils2:ingredients:12>,
    <extrautils2:ingredients:13>,
    <extrautils2:ingredients:14>,
    <extrautils2:ingredients:15>,
    <extrautils2:ingredients:16>,
    <extrautils2:ingredients:17>,
    <extrautils2:contract:*>,
    <extrautils2:ineffableglass:*>,
    <extrautils2:klein>,
    <extrautils2:largishchest>,
    <extrautils2:magicapple>,
    <extrautils2:miner>,
    <extrautils2:minichest>,
    <extrautils2:pipe>,
    <extrautils2:redstonelantern>,
    <extrautils2:sickle_diamond>,
    <extrautils2:sickle_gold>,
    <extrautils2:sickle_iron>,
    <extrautils2:sickle_stone>,
    <extrautils2:sickle_wood>,
    <extrautils2:simpledecorative>,
    <extrautils2:soundmuffler>,
    <extrautils2:wateringcan>.anyDamage(),
    <opencomputers:card:5>,
    <opencomputers:storage:1>,
    <extrautils2:scanner>,
    <extrautils2:user>,
    <extrautils2:teleporter:*>,
    <extrautils2:spike_wood>,
    <extrautils2:spike_stone>,
    <extrautils2:spike_iron>,
    <extrautils2:spike_gold>,
    <extrautils2:spike_diamond>,
    <extrautils2:spike_creative>,
    <extrautils2:opinium:*>,
    <extrautils2:lawsword>,
    <extrautils2:machine>.anyDamage()
] as IIngredient[];
setItemStage(version_1_7,stagedItems_1_7);

val stagedItems_1_10=[
    <minecraft:magma>,
    <minecraft:slime>,
    <tconstruct:slime>,
    <tconstruct:slime:1>,
    <tconstruct:slime:2>,
    <tconstruct:slime:3>,
    <tconstruct:slime:4>,
    <extrautils2:decorativesolid:3>,
    <extrautils2:decorativesolid:7>,
    <extrautils2:resonator>,
    <extrautils2:passivegenerator>.anyDamage(),
    <extrautils2:quarry>,
    <extrautils2:quarryproxy>,
    <extrautils2:biomemarker>.anyDamage(),
    <extrautils2:chunkloader>,
    <extrautils2:compoundbow>,
    <extrautils2:fireaxe>,
    <extrautils2:indexer>,
    <extrautils2:indexerremote>,
    <extrautils2:opinium>,
    <extrautils2:powerbattery>,
    <extrautils2:powermanager>,
    <extrautils2:poweroverload>,
    <extrautils2:powertransmitter>,
    <extrautils2:playerchest>,
    <extrautils2:rainbowgenerator:*>,
    <extrautils2:terraformer:*>,
    <extrautils2:resonator>,
    <extrautils2:screen>,
    <extrautils2:snowglobe>,
    <extrautils2:luxsaber:*>,
    <extrautils2:suncrystal>,
    <extrautils2:interactionproxy>,
    <galacticraftplanets:basic_item_venus:3>,
    <galacticraftplanets:thermal_padding_t2:0>,
    <galacticraftplanets:thermal_padding_t2:1>,
    <galacticraftplanets:thermal_padding_t2:2>,
    <galacticraftplanets:thermal_padding_t2:3>,
    <enderio:item_material:66>,
    <enderio:block_enhanced_alloy_smelter>,
    <enderio:block_enhanced_combustion_generator>,
    <enderio:block_enhanced_sag_mill>,
    <enderio:block_enhanced_vat>,
    <enderio:block_enhanced_wired_charger>,
    <enderio:block_enhanced_wireless_charger>,
    <enderio:block_wireless_charger_extension>,
    <enderio:item_capacitor_stellar>,
    <enderio:item_capacitor_melodic>,
    <enderio:item_capacitor_crystalline>,
    <enderio:item_capacitor_totemic>,
    <enderio:block_solar_panel:4>,
    <enderio:block_solar_panel:5>,
    <enderio:block_solar_panel:6>,
    <enderio:item_endergy_conduit:8>,
    <enderio:item_endergy_conduit:9>,
    <enderio:item_endergy_conduit:10>,
    <enderio:item_endergy_conduit:11>,
    <enderio:item_stellar_alloy_axe>,
    <enderio:item_stellar_alloy_boots>,
    <enderio:item_stellar_alloy_helmet>,
    <enderio:item_stellar_alloy_pickaxe>,
    <enderio:item_stellar_alloy_leggings>,
    <enderio:item_stellar_alloy_chestplate>,
    <enderio:item_end_steel_bow>,
    <enderio:item_end_steel_shield>,
    <enderio:item_end_steel_axe>,
    <enderio:item_end_steel_boots>,
    <enderio:item_end_steel_helmet>,
    <enderio:item_end_steel_pickaxe>,
    <enderio:item_end_steel_leggings>,
    <enderio:item_end_steel_chestplate>,


] as IIngredient[];
setItemStage(version_1_10,stagedItems_1_10);

val stagedItems_1_12=[
    <minecraft:observer>,
    <wirelessutils:positional_ae_network>.anyDamage(),
    <wirelessutils:positional_charger>.anyDamage(),
    <wirelessutils:positional_condenser>.anyDamage(),
    <wirelessutils:positional_desublimator>.anyDamage(),
    <wirelessutils:positional_vaporizer>.anyDamage(),
    <wirelessutils:directional_ae_network>.anyDamage(),
    <wirelessutils:directional_charger>.anyDamage(),
    <wirelessutils:directional_condenser>.anyDamage(),
    <wirelessutils:directional_desublimator>.anyDamage(),
    <wirelessutils:directional_vaporizer>.anyDamage()
    ] as IIngredient[];
setItemStage(version_1_12,stagedItems_1_12);

mods.ItemStages.addItemStage(version_1_7,<extrautils2:decorativesolidwood>.anyDamage());

mods.recipestages.Recipes.setRecipeStageByRegex(version_1_7, "minecraft:.*_stained_glass");

MobStages.addStage(version_1_6, "minecraft:horse");
MobStages.addStage(version_1_10, "minecraft:husk");
MobStages.addStage(version_1_10, "minecraft:stray");
MobStages.addStage(version_1_10, "mekanism:babyskeleton");

// mods.ItemStages.removeItemStage(<extrautils2:compressedcobblestone>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:compresseddirt>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:compressedgravel>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:compressednetherrack>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:compressedsand>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:compressedcobblestone>.anyDamage());
// mods.ItemStages.removeItemStage(<extrautils2:redorchid>);
// mods.ItemStages.removeItemStage(<extrautils2:enderlilly>);
// mods.ItemStages.removeItemStage(<extrautils2:ironwood_log>);
// mods.ItemStages.removeItemStage(<extrautils2:ironwood_planks>);
// mods.ItemStages.removeItemStage(<extrautils2:ironwood_leaves>);
// mods.ItemStages.removeItemStage(<extrautils2:ironwood_sapling>);
// mods.ItemStages.removeItemStage(<extrautils2:ingredients:0>);

// mods.ItemStages.removeItemStage(<mekanism:salt>);
// mods.ItemStages.removeItemStage(<mekanism:saltblock>);
// mods.ItemStages.removeItemStage(<appliedenergistics2:material:5>);
// mods.ItemStages.removeItemStage(<appliedenergistics2:material:3>);
// mods.ItemStages.removeItemStage(<appliedenergistics2:material:46>);