import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import scripts.recipefunctions.recipeAddShapedABACDCABA;
import scripts.recipefunctions.recipeAddShapedRotatedABACDCABA;
import scripts.recipefunctions.recipeAddShapedAAAABAAAA;

function recipeAddMFRBricks(id as string,output as IItemStack,corner as IIngredient,center as IIngredient){
    recipes.addShaped(id,output, [
        [corner,null,corner],
        [null,center,null],
        [corner,null,corner]
    ]);
}
function addBrickRecipes(id as string,large as IItemStack, small as IItemStack, corner as IIngredient,count as int=8){
    recipeAddMFRBricks(id+"_large",large*count,corner,<minecraft:stonebrick>);
    recipeAddMFRBricks(id+"_small",small*count,corner,<minecraft:brick_block>);
    recipes.addShaped(id+"large_to_small", small*4,[
       [large,large],
       [large,large]]);
    recipes.addShapeless(id+"small_to_large", large,[small]);
}
function recipe2x2(id as string,output as IItemStack,input as IIngredient){
    recipes.addShaped(id, output,[
       [input,input],
       [input,input]]);
}
addBrickRecipes("brick_ice",<contenttweaker:brick_ice_large>,<contenttweaker:brick_ice>,<ore:blockIce>);
addBrickRecipes("brick_glowstone",<contenttweaker:brick_glowstone_large>,<contenttweaker:brick_glowstone>,<ore:blockGlowstone>);
addBrickRecipes("brick_lapis",<contenttweaker:brick_lapis_large>,<contenttweaker:brick_lapis>,<ore:blockLapis>);
addBrickRecipes("brick_obsidian",<contenttweaker:brick_obsidian_large>,<contenttweaker:brick_obsidian>,<ore:obsidian>);
addBrickRecipes("brick_pavedstone",<contenttweaker:brick_pavedstone_large>,<contenttweaker:brick_pavedstone>,<minecraft:stone_slab:0>,4);
addBrickRecipes("brick_snow",<contenttweaker:brick_snow_large>,<contenttweaker:brick_snow>,<minecraft:snow>);

recipeAddMFRBricks("brick_large",<contenttweaker:brick_brick_large>*8,<minecraft:brick_block>,<minecraft:stonebrick>);

recipeAddShapedAAAABAAAA("road",<mtetweaks:road_block>*16,<minecraft:stonebrick>,<industrialforegoing:plastic>);
recipeAddMFRBricks("road_lamp",<mtetweaks:road_lamp>*4,<mtetweaks:road_block>,<minecraft:redstone_lamp>);
recipes.addShapeless("road_lamp_invert", <mtetweaks:road_lamp_invert_lit>,[<mtetweaks:road_lamp>]);
recipes.addShapeless("road_lamp_invert_back", <mtetweaks:road_lamp>,[<mtetweaks:road_lamp_invert_lit>]);

recipes.addShaped("plastic_block", <contenttweaker:plastic_block>,[
   [<industrialforegoing:plastic>,<industrialforegoing:plastic>],
   [<industrialforegoing:plastic>,<industrialforegoing:plastic>]]);
recipes.addShapeless("plastic_block_disassemble", <industrialforegoing:plastic>*4, [<contenttweaker:plastic_block>]);

recipe2x2("whitestone_bricks_2", <contenttweaker:white_stone_brick_large>*4,<contenttweaker:white_stone_smooth>);
recipe2x2("whitestone_bricks_small_2", <contenttweaker:white_stone_brick_small>*4,<contenttweaker:white_stone_brick_large>);
furnace.addRecipe(<contenttweaker:white_stone_smooth>, <contenttweaker:white_stone_cobble>,0.1);
recipeAddShapedAAAABAAAA("whitestone_bricks_small",<contenttweaker:white_stone_brick_small>*8,<minecraft:brick_block>,<ore:dyeWhite>);
recipeAddShapedAAAABAAAA("whitestone_bricks",<contenttweaker:white_stone_brick_large>*8,<minecraft:stonebrick>,<ore:dyeWhite>);
recipeAddShapedAAAABAAAA("whitestone",<contenttweaker:white_stone_smooth>*8,<ore:stone>,<ore:dyeWhite>);
recipeAddShapedAAAABAAAA("white_cobble",<contenttweaker:white_stone_cobble>*8,<ore:cobblestone>,<ore:dyeWhite>);
recipeAddShapedAAAABAAAA("white_gravel",<contenttweaker:white_stone_gravel>*8,<ore:gravel>,<ore:dyeWhite>);
recipeAddShapedAAAABAAAA("white_paved_stone",<contenttweaker:white_stone_paved>*4,<minecraft:stone_slab:0>,<ore:dyeWhite>);
recipes.addShapeless("white_paved_stone_2", <contenttweaker:white_stone_paved>,[<contenttweaker:white_stone_smooth>]);

mods.ic2.Macerator.addRecipe(<contenttweaker:white_stone_cobble>, <contenttweaker:white_stone_smooth>);
mods.thermalexpansion.Pulverizer.addRecipe(<contenttweaker:white_stone_cobble>, <contenttweaker:white_stone_smooth>, 1000);
mods.ic2.Macerator.addRecipe(<contenttweaker:white_stone_gravel>, <contenttweaker:white_stone_cobble>);
mods.thermalexpansion.Pulverizer.addRecipe(<contenttweaker:white_stone_gravel>, <contenttweaker:white_stone_cobble>, 4000);


recipe2x2("blackstone_bricks_2", <contenttweaker:black_stone_brick_large>*4,<contenttweaker:black_stone_smooth>);
recipe2x2("blackstone_bricks_small_2", <contenttweaker:black_stone_brick_small>*4,<contenttweaker:black_stone_brick_large>);
furnace.addRecipe(<contenttweaker:black_stone_smooth>, <contenttweaker:black_stone_cobble>,0.1);
recipeAddShapedAAAABAAAA("blackstone_bricks_small",<contenttweaker:black_stone_brick_small>*8,<minecraft:brick_block>,<ore:dyeBlack>);
recipeAddShapedAAAABAAAA("blackstone_bricks",<contenttweaker:black_stone_brick_large>*8,<minecraft:stonebrick>,<ore:dyeBlack>);
recipeAddShapedAAAABAAAA("blackstone",<contenttweaker:black_stone_smooth>*8,<ore:stone>,<ore:dyeBlack>);
recipeAddShapedAAAABAAAA("black_cobble",<contenttweaker:black_stone_cobble>*8,<ore:cobblestone>,<ore:dyeBlack>);
recipeAddShapedAAAABAAAA("black_gravel",<contenttweaker:black_stone_gravel>*8,<ore:gravel>,<ore:dyeBlack>);
recipeAddShapedAAAABAAAA("black_paved_stone",<contenttweaker:black_stone_paved>*4,<minecraft:stone_slab:0>,<ore:dyeBlack>);
recipes.addShapeless("black_paved_stone_2", <contenttweaker:black_stone_paved>,[<contenttweaker:black_stone_smooth>]);

mods.ic2.Macerator.addRecipe(<contenttweaker:black_stone_cobble>, <contenttweaker:black_stone_smooth>);
mods.thermalexpansion.Pulverizer.addRecipe(<contenttweaker:black_stone_cobble>, <contenttweaker:black_stone_smooth>, 1000);
mods.ic2.Macerator.addRecipe(<contenttweaker:black_stone_gravel>, <contenttweaker:black_stone_cobble>);
mods.thermalexpansion.Pulverizer.addRecipe(<contenttweaker:black_stone_gravel>, <contenttweaker:black_stone_cobble>, 4000);