import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.text.ITextComponent;
import crafttweaker.formatting.IFormattedText;

function addWorldspikeFuelTooltip(item as IItemStack, time as string){
    item.addTooltip(game.localize("info.mte.worldspike_fuel.tip")+time+game.localize("info.mte.worldspike_fuel.tip.hours"));
}
addWorldspikeFuelTooltip(<thermalfoundation:material:770>,"2");
addWorldspikeFuelTooltip(<railcraft:dust:0>,"2");
addWorldspikeFuelTooltip(<minecraft:ender_pearl>,"4");
addWorldspikeFuelTooltip(<railcraft:dust:6>,"8");
addWorldspikeFuelTooltip(<ic2:dust:31>,"8");
addWorldspikeFuelTooltip(<appliedenergistics2:material:46>,"8");
addWorldspikeFuelTooltip(<railcraft:dust:7>,"12");

function addBlastFurnaceTooltip(item as IIngredient, time as string){
    item.addTooltip(game.localize("info.mte.blastfurnace_fuel.tip")+time+game.localize("info.mte.blastfurnace_fuel.tip.seconds"));
}
addBlastFurnaceTooltip(<ore:fuelCoke>,"64");
addBlastFurnaceTooltip(<ore:blockFuelCoke>,"640");

addBlastFurnaceTooltip(<minecraft:coal:1>,"16");
addBlastFurnaceTooltip(<ore:blockCharcoal>,"160");

function addTranslatedTooltip(item as IIngredient, langKey as string) as void {
    item.addTooltip(game.localize(langKey));
}

function addTranslatedShiftTooltip(item as IIngredient, langKey as string) as void {
    item.addShiftTooltip(game.localize(langKey),game.localize("info.mte.hold_shift.tip"));
}

addTranslatedTooltip(<contenttweaker:overworld_porter>,"item.contenttweaker.overworld_porter.tooltip");
addTranslatedTooltip(<contenttweaker:overworld_porter>,"item.contenttweaker.overworld_porter.tooltip2");
addTranslatedTooltip(<contenttweaker:overworld_porter>,"item.contenttweaker.overworld_porter.tooltip3");



addTranslatedTooltip(<microblockcbe:microblock:769>.withTag({mat: "minecraft:redstone_block"}),"item.microblockcbe.redstone_strip.info");

addTranslatedTooltip(<microblockcbe:microblock:1>,"item.microblockcbe.cover.info");
addTranslatedTooltip(<microblockcbe:microblock:257>,"item.microblockcbe.cover.info");
addTranslatedTooltip(<microblockcbe:microblock:2>,"item.microblockcbe.panel.info");
addTranslatedTooltip(<microblockcbe:microblock:258>,"item.microblockcbe.panel.info");

addTranslatedTooltip(<energycontrol:item_component:0>,"item.energycontrol.advcircuit.info");

<ic2:te:92>.removeTooltipLine(1);
addTranslatedTooltip(<ic2:te:92>,"item.ic2.massfab.tip");

