import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.text.ITextComponent;
import crafttweaker.formatting.IFormattedText;
import crafttweaker.item.ITooltipFunction;

val keyIc2Mode = ITextComponent.fromKeybind("Mode Switch Key");
val keyIc2Alt = ITextComponent.fromKeybind("ALT Key");
val keyIc2Boost = ITextComponent.fromKeybind("Boost Key");

val keyUse = ITextComponent.fromKeybind("key.use");
val keyJump = ITextComponent.fromKeybind("key.jump");

// val keyShowUsage = ITextComponent.fromKeybind("key.jei.showUses");

var pressShiftFunc as function(IIngredient)string = function (item as IIngredient) as string {
	return game.localize("info.mte.hold_shift.tip");
};

(<ic2:mining_laser>.anyDamage()|
<ic2:foam_sprayer>.anyDamage()|
<ic2:iridium_drill>.anyDamage()).addShiftTooltip(function(item){
    return ITextComponent.fromTranslation("info.mte.ic2_mode_use.tip",
    keyIc2Mode.formattedText,keyUse.formattedText).formattedText;
    },
    pressShiftFunc);

(<ic2:quantum_chestplate>.anyDamage()|
<ic2:jetpack>.anyDamage()|
<ic2:jetpack_electric>.anyDamage()).addShiftTooltip(function(item){
    return ITextComponent.fromTranslation("info.mte.ic2_mode_hover.tip",
    keyJump.formattedText,keyIc2Mode.formattedText).formattedText;
    },pressShiftFunc);

<ic2:quantum_boots>.anyDamage().addShiftTooltip(function(item){
    return ITextComponent.fromTranslation("info.mte.ic2_mode_qboots.tip",
    keyIc2Boost.formattedText,keyJump.formattedText).formattedText;
    },pressShiftFunc);

(<ic2:nightvision_goggles>.anyDamage()|
<ic2:quantum_helmet>.anyDamage()|
<ic2:nano_helmet>.anyDamage()).addShiftTooltip(function(item){
    return ITextComponent.fromTranslation("info.mte.ic2_mode_nightvision.tip",
    keyIc2Alt.formattedText,keyIc2Mode.formattedText).formattedText;
    },pressShiftFunc);

<ic2:te:93>.removeTooltipLine(1);
// <ic2:te:93>.addTooltip(ITextComponent.fromTranslation("item.ic2.uubench.tip",
//     keyShowUsage.formattedText).formattedText);