import mods.ic2.Compressor;
import scripts.recipefunctions.recipeAddShapedABACDCABA;
import scripts.recipefunctions.recipeAddShapedRotatedABACDCABA;
import scripts.recipefunctions.recipeAddShapedAAAABAAAA;

val empty_cell=<ic2:cell>;     //Empty Cell
val water_cell=<ic2:cell:1>;     //Water Cell
val lava_cell=<ic2:cell:2>;     //Lava Cell
val compressed_air_cell=<ic2:cell:3>;     //Compressed Air Cell
val electrolyzed_water_cell=<ic2:cell:4>;     //Electrolyzed Water Cell
val biofuel_cell=<ic2:cell:5>;     //Biofuel Cell
val coalfuel_cell=<ic2:cell:6>;     //Coalfuel Cell
val bio_cell=<ic2:cell:7>;     //Bio Cell
val hcoal_cell=<ic2:cell:8>;     //H.Coal Cell
val weedex_cell=<ic2:cell:9>;     //Weed-EX
val hydration_cell=<ic2:cell:10>;     //Hydration Cell
val refined_iron=<ic2:ingot:7>;    //Refined Iron
val uranium_ingot=<ic2:ingot:8>;    //Uranium
val cf_pellet=<ic2:crafting:26>;    //CF Pellet
val hcoal=<ic2:crafting:22>;    //H.Coal
val compressed_plants=<ic2:crafting:39>;    //Compressed Plants
val fuel_can_empty=<ic2:crafting:40>;    //Fuel Can Empty
val lappack=<ic2:lappack>;    //Lapotron Pack
val machine_block=<contenttweaker:machine_block>;
val advanced_machine_block=<contenttweaker:advanced_machine_block>;

mods.ic2.Compressor.addRecipe(compressed_plants, <ic2:crafting:20>);    //Compressed Plants
mods.ic2.Compressor.addRecipe(hcoal, <ic2:dust:3>);           //H.Coal

recipes.addShaped(fuel_can_empty,[  //Fuel Can Empty
    [null,<ore:ingotTin>,<ore:ingotTin>],
    [<ore:ingotTin>,null,<ore:ingotTin>],
    [<ore:ingotTin>,<ore:ingotTin>,<ore:ingotTin>]]);

recipes.addShaped(empty_cell*16,[[null,<ore:ingotTin>,null],[<ore:ingotTin>,null,<ore:ingotTin>],[null,<ore:ingotTin>,null]]); //Cell

<ore:cellDisposable>.add(empty_cell);
<ore:cellDisposable>.add(<forestry:can>);
<ore:cellDisposable>.add(<forestry:capsule>);
<ore:cellDisposable>.add(<forestry:refractory>);

recipes.addShapeless(bio_cell,[compressed_plants,<ore:cellDisposable>]);    //Bio Cell
recipes.addShapeless(hcoal_cell,[hcoal,<ore:cellDisposable>]);    //H.Coal Cell

mods.ic2.Extractor.addRecipe(biofuel_cell,bio_cell);                //Biofuel
mods.ic2.Extractor.addRecipe(coalfuel_cell,hcoal_cell);                //Coalfuel

mods.ic2.Canner.addBottleRecipe(<ic2:filled_fuel_can>.withTag({value:5208}),fuel_can_empty, biofuel_cell*6);  //26040 EU
mods.ic2.Canner.addBottleRecipe(<ic2:filled_fuel_can>.withTag({value:15288}),fuel_can_empty, coalfuel_cell*6); //76440 EU

mods.jei.JEI.addItem(<ic2:filled_fuel_can>.withTag({value:5208}));
mods.jei.JEI.addDescription(<ic2:filled_fuel_can>.withTag({value:5208}),"A fuel can filled With 6 Biofuel cells.");
mods.jei.JEI.addItem(<ic2:filled_fuel_can>.withTag({value:15288}));
mods.jei.JEI.addDescription(<ic2:filled_fuel_can>.withTag({value:15288}),"A fuel can filled With 6 Coalfuel cells.");

mods.ic2.Macerator.addRecipe(<galacticraftcore:ic2compat:2>, <thermalfoundation:ore:4>);

recipes.addShaped("electric_boat", <ic2:boat:3>,[
   [<ore:itemInsulatedCopperCable>,<ore:itemInsulatedCopperCable>,<ore:itemInsulatedCopperCable>],
   [<ore:ingotRefinedIron>,<ic2:te:10>,<ore:ingotRefinedIron>],
   [<ore:ingotRefinedIron>,<ore:ingotRefinedIron>,<ore:ingotRefinedIron>]]);

recipeAddShapedABACDCABA("ic2_10k_coolant_cell", <ic2:heat_storage>.withTag({advDmg: 0}),null,<ore:plateTin>,<ore:plateTin>,<liquid:ic2coolant>*1000);
recipeAddShapedAAAABAAAA("ic2_hydrated_coal_dust", <ic2:dust:3>,<ore:dustCoal>,<liquid:water>*1000);
recipeAddShapedABACDCABA("ic2_refractory_bricks", <ic2:refractory_bricks>,<minecraft:clay_ball>,<minecraft:brick>,<minecraft:brick>,<liquid:water>*1000);

recipes.addShaped("ic2_steam_turbine_v", <ic2:crafting:36>,[
   [<ic2:crafting:35>],
   [<ic2:crafting:35>],
   [<ic2:crafting:35>]]);
recipes.addShaped("ic2_steam_turbine_h", <ic2:crafting:36>,[
   [<ic2:crafting:35>,<ic2:crafting:35>,<ic2:crafting:35>]]);