import scripts.recipefunctions.recipeAddShapedABACDCABA;
import scripts.recipefunctions.recipeAddShapedAAAABAAAA;
import scripts.recipefunctions.recipeAddShapedRotatedABACDCABA;

import crafttweaker.data.IData;
import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import crafttweaker.liquid.ILiquidStack;

function getLiquidAmount(item as IItemStack) as int{
   if (item.liquid) {
      return item.liquid.amount;
   } else {
      return 0;
   }
}
function minInt(a as int,b as int) as int{
   if(a<b){
      return a;
   }else{
      return b;
   }
}

recipes.addShaped("ic2legacy_foam_sprayer", <ic2:foam_sprayer>,[
   [<ore:ingotRefinedIron>,null,null],
   [null,<ore:ingotRefinedIron>,null],
   [null,<ic2:crafting:40>,<ore:ingotRefinedIron>]]);

recipes.addShaped("ic2legacy_foam_pack", <ic2:cf_pack:27>,[
   [<ic2:foam_sprayer>.anyDamage().marked("tank1").noReturn(),<ore:circuitBasic>,<ic2:foam_sprayer>.anyDamage().marked("tank2").noReturn()],
   [<ic2:crafting:40>,<ore:ingotTin>,<ic2:crafting:40>],
   [<ic2:crafting:40>,null,<ic2:crafting:40>]],
   function(out, ins, cInfo){
         var amount=getLiquidAmount(ins.tank1)+getLiquidAmount(ins.tank2);
         return <ic2:cf_pack>.withDamage(27-amount/1153).withTag({Fluid: {FluidName: "ic2construction_foam", Amount: amount}});
         },null);

recipes.addShaped("ic2legacy_jetpack", <ic2:jetpack:27>,[
   [<ore:ingotRefinedIron>,<ore:circuitBasic>,<ore:ingotRefinedIron>],
   [<ore:ingotRefinedIron>,<ic2:crafting:40>,<ore:ingotRefinedIron>],
   [<ore:dustRedstone>,null,<ore:dustRedstone>]]);

var listCF=[<ic2:foam_sprayer>.anyDamage().marked("tank1").noReturn()] as IIngredient[];
var listCFPack=[<ic2:cf_pack>.anyDamage().marked("tank1").noReturn()] as IIngredient[];
var listBiofuel=[<ic2:jetpack>.anyDamage().marked("tank1").noReturn()] as IIngredient[];
var listCoalfuel=[<ic2:jetpack>.anyDamage().marked("tank1").noReturn()] as IIngredient[];
for i in 1 to 9 {
   listCF+=<ic2:crafting:26>;
   listCFPack+=<ic2:crafting:26>;
   listBiofuel+=<ic2:cell:5>;
   listCoalfuel+=<ic2:cell:6>;
   recipes.addShapeless("ic2_foam_refill_"+i,<ic2:foam_sprayer>.withTag({Fluid: {FluidName: "ic2construction_foam", Amount: 1000*i}}).withLore(["Fill "+1000*i+"mB"]),listCF,
      function(out, ins, cInfo){
      var amount=minInt(getLiquidAmount(ins.tank1)+1000*i,8000);
      return ins.tank1.withTag({Fluid: {FluidName: "ic2construction_foam", Amount: amount}});},null);
   recipes.addShapeless("ic2_foampack_refill_"+i,<ic2:cf_pack>.withDamage( 27 - 1000 * i / 3077 ).withTag({Fluid: {FluidName: "ic2construction_foam", Amount: 1000*i}}).withLore(["Fill "+1000*i+"mB"]),listCFPack,
      function(out, ins, cInfo){
      var amount=minInt(getLiquidAmount(ins.tank1)+1000*i,80000);
      return ins.tank1.withDamage(27-amount/3077).withTag({Fluid: {FluidName: "ic2construction_foam", Amount: amount}});},null);
   recipes.addShapeless("ic2_jetpack_refill_biofuel_"+i,<ic2:jetpack>.withDamage( 27 - 434 * i / 1153 ).withTag({Fluid: {FluidName: "ic2biogas", Amount: 434*i}}).withLore(["Fill "+434*i+"mB"]),listBiofuel,
      function(out, ins, cInfo){
         var amount=getLiquidAmount(ins.tank1);
            var setamount=minInt(amount+434*i,30000);
            return ins.tank1.withDamage(27-setamount/1153).withTag({Fluid: {FluidName: "ic2biogas", Amount: setamount}});},null);
   recipes.addShapeless("ic2_jetpack_refill_coalfuel_"+i,<ic2:jetpack>.withDamage( 27 - 1274 * i / 1153 ).withTag({Fluid: {FluidName: "ic2biogas", Amount: 1274*i}}).withLore(["Fill "+1274*i+"mB"]),listCoalfuel,
      function(out, ins, cInfo){
         var amount=getLiquidAmount(ins.tank1);
            var setamount=minInt(amount+1274*i,30000);
            return ins.tank1.withDamage(27-setamount/1153).withTag({Fluid: {FluidName: "ic2biogas", Amount: setamount}});
            return ins.tank1;},null);
}

recipes.addShapeless("ic2_jetpack_refill",<ic2:jetpack>.withLore(["Refill"]),[<ic2:jetpack>.anyDamage().marked("tank1").noReturn(),<ic2:filled_fuel_can>.anyDamage().marked("tank2")],
   function(out, ins, cInfo){
	var amount=getLiquidAmount(ins.tank1);
    if(ins.tank2.tag.value){
      var setamount=minInt(amount+ins.tank2.tag.value.asInt()/2,30000);
	    return ins.tank1.withDamage(27-setamount/1153).withTag({Fluid: {FluidName: "ic2biogas", Amount: setamount}});
    }else{
	    return ins.tank1;
    }},null);