import scripts.recipefunctions.recipeAddShapedABACDCABA;
import scripts.recipefunctions.recipeAddShapedAAAABAAAA;
import scripts.recipefunctions.recipeAddShapedRotatedABACDCABA;
import crafttweaker.data.IData;
import crafttweaker.item.IItemStack;

val refined_iron=<ic2:ingot:7>;    //Refined Iron
val uranium_ingot=<ic2:ingot:8>;    //Uranium
val cf_pellet=<ic2:crafting:26>;    //CF Pellet
val hcoal=<ic2:crafting:22>;    //H.Coal
val compressed_plants=<ic2:crafting:39>;    //Compressed Plants
val fuel_can_empty=<ic2:crafting:40>;    //Fuel Can Empty
val lappack=<ic2:lappack>;    //Lapotron Pack
val machine_block=<contenttweaker:machine_block>;
val advanced_machine_block=<contenttweaker:advanced_machine_block>;
val generator=<ic2:te:3>;

function getCharge(item as IItemStack) as double{
   // Fix null tag fails crafting
   if(isNull(item.tag)){
      return 0.0;
   }
   if (!isNull(item.tag.charge)) {
      return item.tag.charge.asDouble();
   } else if(!isNull(item.tag.energy)) {
      return item.tag.energy.asDouble();
   }else {
      return 0.0;
   }
}
function getTotalCharge(items as IItemStack[]) as double{
   var charge=0.0 as double;
   for item in items {
      charge+=getCharge(item);
   }
   return charge;
}
function minDouble(a as double,b as double) as double{
   if(a<b){
      return a;
   }else{
      return b;
   }
}

recipes.addShaped("ic2legacy_advrebattery", <ic2:re_battery:26>,[
   [null,<ore:itemInsulatedTinCable>,null],
   [<ore:ingotTin>,<ore:dustRedstone>,<ore:ingotTin>],
   [<ore:ingotTin>,<ore:dustRedstone>,<ore:ingotTin>]]);

recipes.addShaped("ic2legacy_cesu", <ic2:te:73>,[
   [<ore:ingotBronze>,<ore:itemInsulatedCopperCable>,<ore:ingotBronze>],
   [<ic2:advanced_re_battery>.anyDamage().marked("bat1"),<ic2:advanced_re_battery>.anyDamage().marked("bat2"),<ic2:advanced_re_battery>.anyDamage().marked("bat3")],
   [<ore:ingotBronze>,<ore:ingotBronze>,<ore:ingotBronze>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2,ins.bat3]);
   //Return the result with charge kept
	return <ic2:te:73>.withTag({energy: charge});}, null);
   
recipes.addShaped("ic2legacy_mfe", <ic2:te:74>,[
   [<ore:itemInsulatedGoldCable>,<ic2:energy_crystal:26>.anyDamage().marked("bat1"),<ore:itemInsulatedGoldCable>],
   [<ic2:energy_crystal:26>.anyDamage().marked("bat2"),machine_block,<ic2:energy_crystal:26>.anyDamage().marked("bat3")],
   [<ore:itemInsulatedGoldCable>,<ic2:energy_crystal:26>.anyDamage().marked("bat4"),<ore:itemInsulatedGoldCable>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2,ins.bat3,ins.bat4]);
	return <ic2:te:74>.withTag({energy: charge});},null);

recipes.addShaped("ic2legacy_mfsu", <ic2:te:75>,[
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat1"),<ore:circuitAdvanced>,<ic2:lapotron_crystal:26>.anyDamage().marked("bat4")],
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat2"),<ic2:te:74>.marked("bat7"),<ic2:lapotron_crystal:26>.anyDamage().marked("bat5")],
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat3"),advanced_machine_block,<ic2:lapotron_crystal:26>.anyDamage().marked("bat6")]],
   function(out, ins, cInfo){
	var charge=minDouble(getTotalCharge([ins.bat1,ins.bat2,ins.bat3,ins.bat4,ins.bat5,ins.bat6,ins.bat7]),40000000);
	return <ic2:te:75>.withTag({energy: charge});},null);

recipes.addShaped("ic2legacy_mfsu_upgrade_kit", <ic2:upgrade_kit>,[
   [<ic2:lapotron_crystal:26>.anyDamage(),<ore:circuitAdvanced>,<ic2:lapotron_crystal:26>.anyDamage()],
   [<ic2:lapotron_crystal:26>.anyDamage(),<ic2:wrench> | <ic2:wrench_new>,<ic2:lapotron_crystal:26>.anyDamage()],
   [<ic2:lapotron_crystal:26>.anyDamage(),advanced_machine_block,<ic2:lapotron_crystal:26>.anyDamage()]]);

recipes.addShaped("ic2legacy_mfsu_chargepad", <ic2:te:71>,[
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat1"),<ore:circuitAdvanced>,<ic2:lapotron_crystal:26>.anyDamage().marked("bat4")],
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat2"),<ic2:te:70>.marked("bat7"),<ic2:lapotron_crystal:26>.anyDamage().marked("bat5")],
   [<ic2:lapotron_crystal:26>.anyDamage().marked("bat3"),advanced_machine_block | <ic2:resource:13>,<ic2:lapotron_crystal:26>.anyDamage().marked("bat6")]],
   function(out, ins, cInfo){
	var charge=minDouble(getTotalCharge([ins.bat1,ins.bat2,ins.bat3,ins.bat4,ins.bat5,ins.bat6,ins.bat7]),40000000);
	return <ic2:te:71>.withTag({energy: charge});},null);

recipes.addShaped("ic2legacy_adv_batpack", <ic2:advanced_batpack>,[
   [<ic2:advanced_re_battery>.anyDamage().marked("bat1"),<ore:circuitBasic>,<ic2:advanced_re_battery>.anyDamage().marked("bat4")],
   [<ic2:advanced_re_battery>.anyDamage().marked("bat2"),<ore:ingotCopper>,<ic2:advanced_re_battery>.anyDamage().marked("bat5")],
   [<ic2:advanced_re_battery>.anyDamage().marked("bat3"),null,<ic2:advanced_re_battery>.anyDamage().marked("bat6")]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2,ins.bat3,ins.bat4,ins.bat5,ins.bat6]);
	return <ic2:advanced_batpack>.withTag({charge: charge});},null);

recipes.addShaped("ic2legacy_electric_jetpack", <ic2:jetpack_electric>,[
   [<ore:ingotRefinedIron>,<ore:circuitAdvanced>,<ore:ingotRefinedIron>],
   [<ore:ingotRefinedIron>,<ic2:te:72>.marked("bat1"),<ore:ingotRefinedIron>],
   [<ore:dustGlowstone>,null,<ore:dustGlowstone>]],
   function(out, ins, cInfo){
	var charge=minDouble(getCharge(ins.bat1),30000);
	return <ic2:jetpack_electric>.withTag({charge: charge});},null);

recipes.addShaped("ic2legacy_energypack", <ic2:energy_pack>,[
   [<ore:circuitBasic>,<ore:ingotRefinedIron>,<ore:circuitBasic>],
   [<ic2:energy_crystal>.anyDamage().marked("bat1"),<ore:ingotRefinedIron>,<ic2:energy_crystal>.anyDamage().marked("bat2")],
   [<ore:ingotRefinedIron>,null,<ore:ingotRefinedIron>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2]);
	return <ic2:energy_pack>.withTag({charge: charge});},null);

recipes.addShaped("ic2legacy_lappack", <ic2:lappack>,[
   [<ore:circuitAdvanced>,<ore:plateAdvancedAlloy>,<ore:circuitAdvanced>],
   [<ic2:lapotron_crystal>.anyDamage().marked("bat1"),<ore:plateAdvancedAlloy>,<ic2:lapotron_crystal>.anyDamage().marked("bat2")],
   [<ore:plateAdvancedAlloy>,null,<ore:plateAdvancedAlloy>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2]);
	return <ic2:lappack>.withTag({charge: minDouble(charge,20000000)});},null);

recipes.addShaped("ic2legacy_odscanner", <ic2:scanner>,[
   [<ore:ingotGold>,<ore:dustGlowstone>,<ore:ingotGold>],
   [<ore:circuitBasic>,<ic2:advanced_re_battery>.anyDamage().marked("bat1"),<ore:circuitBasic>],
   [<ore:itemInsulatedCopperCable>,<ore:itemInsulatedCopperCable>,<ore:itemInsulatedCopperCable>]],
   function(out, ins, cInfo){
	var charge=getCharge(ins.bat1);
	return <ic2:scanner>.withTag({charge: charge});},null);
   
recipes.addShaped("ic2legacy_ovscanner", <ic2:advanced_scanner>,[
   [<ore:ingotGold>,<ic2:energy_crystal:26>.anyDamage().marked("bat1"),<ore:ingotGold>],
   [<ore:dustGlowstone>,<ore:circuitAdvanced>,<ore:dustGlowstone>],
   [<ore:itemInsulatedGoldCable>,<ic2:scanner:26>.anyDamage().marked("bat2"),<ore:itemInsulatedGoldCable>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2]);
	return <ic2:advanced_scanner>.withTag({charge: minDouble(charge,1000000)});},null);

recipes.addShaped("ic2legacy_quantumleggings", <ic2:quantum_leggings>,[
   [machine_block,<ic2:lapotron_crystal:26>.anyDamage().marked("bat1"),machine_block],
   [<ic2:crafting:4>,<ic2:nano_leggings:26>.anyDamage().marked("bat2"),<ic2:crafting:4>],
   [<ore:dustGlowstone>,null,<ore:dustGlowstone>]],
   function(out, ins, cInfo){
	var charge=getTotalCharge([ins.bat1,ins.bat2]);
	return <ic2:quantum_leggings>.withTag({charge: minDouble(charge,1000000)});},null);

recipes.addShaped("hazmat_charm", <mtetweaks:hazmat_charm>,[
   [<thermalfoundation:material:358>,<ic2:crafting:4>,<thermalfoundation:material:358>],
   [<ic2:crafting:4>,<ic2:lapotron_crystal>.anyDamage().marked("bat1"),<ic2:crafting:4>],
   [<thermalfoundation:material:358>,<thermalfoundation:material:295>,<thermalfoundation:material:358>]],
   function(out, ins, cInfo){
	var charge=getCharge(ins.bat1);
	return <mtetweaks:hazmat_charm>.withTag({charge: minDouble(charge,1000000)});},null);