#loader contenttweaker

import mods.contenttweaker.Item;
import mods.contenttweaker.ResourceLocation;
import crafttweaker.creativetabs.ICreativeTab;
import mods.contenttweaker.CreativeTab;
import mods.contenttweaker.SoundType;
import mods.contenttweaker.Facing;

var creativeTab=<creativetab:pack_content>;

function createDecoBlock(id as string,tab as CreativeTab,lightValue as int,soundtype as SoundType = <soundtype:stone>,hardness as int = 1.5,resistance as int = 6.0){
var block1=mods.contenttweaker.VanillaFactory.createBlock(id,<blockmaterial:rock>);
block1.creativeTab=tab;
block1.setBlockHardness(hardness);
block1.setBlockResistance(resistance);
block1.setToolClass("pickaxe");
block1.setToolLevel(-1);
block1.setLightValue(lightValue);
block1.setBlockSoundType(soundtype);
block1.register();
}

function createDecoBlockTranslucent(id as string,tab as CreativeTab,lightValue as int,soundtype as SoundType = <soundtype:stone>){
var block1=mods.contenttweaker.VanillaFactory.createBlock(id,<blockmaterial:rock>);
block1.creativeTab=tab;
block1.setBlockHardness(1.5);
block1.setBlockResistance(10.0);
block1.setFullBlock(false);
block1.setToolClass("pickaxe");
block1.setToolLevel(-1);
block1.setLightValue(lightValue);
block1.setLightOpacity(1);
block1.translucent=true;
block1.blockLayer="TRANSLUCENT";
block1.setBlockSoundType(soundtype);
block1.register();
}
createDecoBlock("black_stone_brick_large",creativeTab,0);
createDecoBlock("black_stone_brick_small",creativeTab,0);
createDecoBlock("black_stone_cobble",creativeTab,0);
createDecoBlock("black_stone_gravel",creativeTab,0);
createDecoBlock("black_stone_paved",creativeTab,0);
createDecoBlock("black_stone_smooth",creativeTab,0);
createDecoBlock("brick_brick_large",creativeTab,0);
createDecoBlock("brick_glowstone_large",creativeTab,1,<soundtype:glass>);
createDecoBlock("brick_glowstone",creativeTab,1,<soundtype:glass>);
createDecoBlock("brick_ice_large",creativeTab,0,<soundtype:glass>);
createDecoBlock("brick_ice",creativeTab,0,<soundtype:glass>);
// createDecoBlockTranslucent("brick_ice_large_tl",creativeTab,0,<soundtype:glass>);
// createDecoBlockTranslucent("brick_ice_tl",creativeTab,0,<soundtype:glass>);
createDecoBlock("brick_lapis_large",creativeTab,0);
createDecoBlock("brick_lapis",creativeTab,0);
createDecoBlock("brick_obsidian_large",creativeTab,0,<soundtype:stone>,50.0,60.0);
createDecoBlock("brick_obsidian",creativeTab,0,<soundtype:stone>,50.0,60.0);
createDecoBlock("brick_pavedstone_large",creativeTab,0);
createDecoBlock("brick_pavedstone",creativeTab,0);
createDecoBlock("brick_snow_large",creativeTab,0,<soundtype:snow>);
createDecoBlock("brick_snow",creativeTab,0,<soundtype:snow>);
createDecoBlock("white_stone_brick_large",creativeTab,0);
createDecoBlock("white_stone_brick_small",creativeTab,0);
createDecoBlock("white_stone_cobble",creativeTab,0);
createDecoBlock("white_stone_gravel",creativeTab,0);
createDecoBlock("white_stone_paved",creativeTab,0);
createDecoBlock("white_stone_smooth",creativeTab,0);
createDecoBlock("plastic_block",creativeTab,0);