/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.miningspeedlimiter;

import io.bluebeaker.miningspeedlimiter.MiningSpeedLimiterConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Controller {
    public final KeyBinding keyInstaMineLimiter = new KeyBinding("key.insta_mine_limiter", (IKeyConflictContext)KeyConflictContext.IN_GAME, 42, "Mining Speed Limiter");
    public static final Controller INSTANCE = new Controller();
    public int tickInterval = 0;
    private final Minecraft mc = Minecraft.func_71410_x();

    private Controller() {
    }

    public boolean canBreakNow() {
        return this.tickInterval <= 0 || !this.isLimitActive();
    }

    public boolean isLimitActive() {
        if (MiningSpeedLimiterConfig.mode == MiningSpeedLimiterConfig.MODE.ALWAYS) {
            return true;
        }
        if (MiningSpeedLimiterConfig.mode == MiningSpeedLimiterConfig.MODE.NEVER) {
            return false;
        }
        return MiningSpeedLimiterConfig.mode == MiningSpeedLimiterConfig.MODE.WITH_KEYBIND == this.keyInstaMineLimiter.func_151470_d();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.mc.field_71474_y.field_74312_F.func_151470_d()) {
            this.tickInterval = 0;
        } else if (this.tickInterval > 0) {
            --this.tickInterval;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerBreakingBlock(PlayerEvent.BreakSpeed event) {
        float newSpeed;
        if (!this.isLimitActive()) {
            return;
        }
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer != this.mc.field_71439_g) {
            return;
        }
        float blockHardness = event.getState().func_185887_b(entityPlayer.field_70170_p, event.getPos());
        if (blockHardness * 30.0f <= (newSpeed = event.getNewSpeed())) {
            this.tickInterval = MiningSpeedLimiterConfig.interval + 1;
        }
    }
}

